using System;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class ImpressionLimits
    {
        [JsonProperty("global")]
        [CanBeNull]
        public int? GlobalLimit { get; set; }

        [JsonProperty("session")]
        [CanBeNull]
        public int? SessionLimit { get; set; }

        [JsonProperty(PropertyName = "day")]
        [CanBeNull]
        private int? DayLimit { set => DailyLimit = value; }

        [JsonProperty(PropertyName = "daily")]
        [CanBeNull]
        public int? DailyLimit { get; set; }

        [JsonProperty("period_limit")]
        [CanBeNull]
        public int? PeriodLimit { get; set; }

        [JsonProperty("period")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Minute)]
        [CanBeNull]
        public TimeSpan? Period { get; set; }
    }
}