using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class CampaignsContext
    {
        [JsonProperty("limits")]
        [CanBeNull]
        public Limits Limits { get; set; }

        [JsonProperty("campaigns")]
        [CanBeNull]
        public List<CampaignModel> CampaignModels { get; set; }

        [JsonProperty("segmentations")]
        [CanBeNull]
        public string[] Segmentations { get; set; }

        [JsonProperty("product_ids")]
        [CanBeNull]
        public List<DefaultProduct> DefaultProducts { get; set; }

        [JsonProperty("content")]
        [CanBeNull]
        public Dictionary<string, ContentGroup> Content { get; set; }

        [JsonProperty("stored_app_features")]
        [CanBeNull]
        public Dictionary<string, FeatureConfig> StoredAppFeatures { get; set; }

        [JsonProperty("default_content")]
        [CanBeNull]
        public List<DefaultContentItem> DefaultContent { get; set; }

        [JsonProperty("app_features")]
        [CanBeNull]
        public Dictionary<string, FeatureConfig> Features { get; set; }

        [JsonProperty("ab_tests")]
        [CanBeNull]
        public List<AbTestInfo> AssignedAbTests { get; set; }

        [JsonProperty("tracked_app_ids")]
        [CanBeNull]
        public HashSet<string> TrackedAppIds { get; set; }

        [JsonProperty("context_built_at")]
        [JsonConverter(typeof(UnitDateTimeConverter), TimeUnit.Second, true)]
        [CanBeNull]
        public DateTime? ContextBuildTime { get; set; }

        [JsonIgnore]
        public ConfigScope RequestedScopes { get; set; } = ConfigScope.None;

        [CanBeNull]
        public static CampaignsContext Deserialize(string json)
        {
            // TODO handle all possible deserialization errors here
            // TODO for example - unexpected enum values
            if (string.IsNullOrEmpty(json))
            {
                return null;
            }

            var context = JsonFacade.DeserializeObject<CampaignsContext>(json);
            return context;
        }

        public void PullChangesFrom([NotNull] CampaignsContext other)
        {
            if (hasFlag(ConfigScope.Limits)) Limits = other.Limits;
            if (hasFlag(ConfigScope.Campaigns)) CampaignModels = other.CampaignModels;
            if (hasFlag(ConfigScope.ProductIds)) DefaultProducts = other.DefaultProducts;
            if (hasFlag(ConfigScope.Content)) Content = other.Content;
            if (hasFlag(ConfigScope.AppFeatures)) Features = other.Features;
            if (hasFlag(ConfigScope.Segmentations)) Segmentations = other.Segmentations;
            if (hasFlag(ConfigScope.AbTests)) AssignedAbTests = other.AssignedAbTests;
            // DefaultContent ignores, it is only in default context
            ContextBuildTime = other.ContextBuildTime;

            bool hasFlag(ConfigScope scope)
            {
                return other.RequestedScopes == ConfigScope.None || other.RequestedScopes.HasFlag(scope);
            }
        }
    }
}