using System;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class Trigger : Event
    {
        [JsonProperty("is_showing")]
        [CanBeNull]
        public bool? ShowOnStart { get; set; }

        [JsonProperty("is_priority_launch")]
        [CanBeNull]
        public bool? IsPriorityLaunch { get; set; }

        [JsonProperty("activation_global_limit")]
        [CanBeNull]
        public int? ActivationGlobalLimit { get; set; }

        [JsonProperty("activation_session_limit")]
        [CanBeNull]
        public int? ActivationSessionLimit { get; set; }

        [JsonProperty("activation_daily_limit")]
        [CanBeNull]
        public int? ActivationDailyLimit { get; set; }

        [JsonProperty("activation_period_limit")]
        [CanBeNull]
        public int? ActivationPeriodLimit { get; set; }

        [JsonProperty("activation_period")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Minute)]
        [CanBeNull]
        public TimeSpan? ActivationPeriod { get; set; }
    }
}