using System;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class SplashscreenContext
    {
        [JsonProperty("timeout")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Second, true)]
        [CanBeNull]
        public TimeSpan? Timeout { get; set; }

        [JsonProperty("exact_time")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Second, true)]
        [CanBeNull]
        public TimeSpan? Time { get; set; }

        [JsonProperty("max_time")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Second, true)]
        [CanBeNull]
        public TimeSpan? MaxTime { get; set; }

        [JsonProperty("min_time")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Second, true)]
        [CanBeNull]
        public TimeSpan? MinTime { get; set; }

        [JsonProperty("is_forced")]
        [CanBeNull]
        public bool? IsForced { get; set; }
    }
}