using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class CreativeInfo
    {
        [JsonProperty("key")]
        [CanBeNull]
        public string Id { get; set; }

        [JsonProperty("value")]
        [CanBeNull]
        public Dictionary<string, object> Attributes { get; set; } = new();

        [JsonProperty("customs")]
        [CanBeNull]
        public Dictionary<string, object> CustomAttributes { get; set; } = new();

        [JsonProperty("lang")]
        [CanBeNull]
        public string Language { get; set; }

        [JsonProperty("title")]
        [CanBeNull]
        public string Title { get; set; }

        [JsonProperty("body")]
        [CanBeNull]
        public string Message { get; set; }

        [JsonProperty("close_btn")]
        [CanBeNull]
        public string CloseBtn { get; set; }

        [JsonProperty("action_btn")]
        [CanBeNull]
        public string ActionBtn { get; set; }

        [JsonProperty("portrait")]
        [CanBeNull]
        public string Portrait { get; set; }

        [JsonProperty("landscape")]
        [CanBeNull]
        public string Landscape { get; set; }

        [JsonProperty("close_button_show_timeout")]
        [JsonConverter(typeof(UnitTimeSpanConverter), TimeUnit.Second)]
        [CanBeNull]
        public TimeSpan? ShowButtonTimeout { get; set; }

        [JsonProperty("url")]
        [CanBeNull]
        public string PageUrl { get; set; }
    }
}