using System;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class ActivationPeriod
    {
        [JsonProperty("start_weekday")]
        [JsonConverter(typeof(DayOfWeekConverter))]
        public DayOfWeek? StartDay { get; set; }

        [JsonProperty("start_time")]
        [JsonConverter(typeof(DateFormatConverter), "HH:mm:ss")]
        public DateTime? StartTime { get; set; }

        [JsonProperty("end_weekday")]
        [JsonConverter(typeof(DayOfWeekConverter))]
        public DayOfWeek? EndDay { get; set; }

        [JsonProperty("end_time")]
        [JsonConverter(typeof(DateFormatConverter), "HH:mm:ss")]
        public DateTime? EndTime { get; set; }

        [JsonProperty("is_force_stop")]
        [CanBeNull]
        public bool? ForceStop { get; set; }

        [JsonProperty("activation_period_limit")]
        [CanBeNull]
        public int? ActivationLimit { get; set; }
    }
}