using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class CustomSessionEvent : IAnalyticsEvent
    {
        [JsonProperty("event_name")]
        public string EventName { get; init; }

        [JsonProperty("session_id")]
        public string SessionId { get; init; }

        [JsonProperty("custom_params"), CanBeNull]
        public Dictionary<string, object> Params { get; init; }

        [JsonProperty("subscriptionStatus")]
        public SubscriptionStatus SubscriptionStatus { get; init; }

        [JsonProperty("inAppStatus")]
        public InAppStatus InAppStatus { get; init; }

        [JsonProperty("mode"), CanBeNull]
        public string Mode { get; init; }

        [JsonProperty("maxLevel")]
        public int? MaxLevel { get; init; }

        [JsonProperty("level")]
        public int? Level { get; init; }

        [JsonProperty("sessionNumber")]
        public int? SessionNumber { get; init; }

        [JsonProperty("original_app_version")]
        public string AppVersion { get; init; }

        [JsonProperty("timestamp")]
        public double Timestamp { get; set; } = TimestampExtensions.UtcNowTimestamp;

        [JsonProperty("isBasicIntegration"), CanBeNull]
        public bool? IsBasicIntegration { get; init; }

        /// <remarks>
        /// For deserialization
        /// </remarks>
        public CustomSessionEvent()
        {
        }

        public CustomSessionEvent(
            string eventName,
            string sessionId,
            SubscriptionStatus subscription,
            InAppStatus inApp,
            Dictionary<string, object> parameters,
            LevelStateInfo levelState,
            int sessionNumber,
            string appVersion)
        {
            EventName = eventName;
            SessionId = sessionId;
            Params = parameters;
            SubscriptionStatus = subscription;
            InAppStatus = inApp;
            Mode = levelState.Mode;
            MaxLevel = levelState.MaxLevel;
            Level = levelState.Level;
            SessionNumber = sessionNumber;
            AppVersion = appVersion;
        }
    }
}