using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class AppLaunchEvent : IAnalyticsEvent
    {
        [JsonProperty("subscriptionStatus")]
        public SubscriptionStatus SubscriptionStatus { get; init; }

        [JsonProperty("inAppStatus")]
        public InAppStatus InAppStatus { get; init; }

        [JsonProperty("original_app_version")]
        public string AppVersion { get; init; }

        [JsonProperty("timestamp")]
        public double Timestamp { get; init; } = TimestampExtensions.UtcNowTimestamp;

        [JsonProperty("isBasicIntegration"), CanBeNull]
        public bool? IsBasicIntegration { get; init; }

        /// <remarks>
        /// For deserialization
        /// </remarks>
        public AppLaunchEvent()
        {
        }
    }
}