using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Magify.Model;
using Newtonsoft.Json;

namespace Magify
{
    internal class MigrationData
    {
        #region 1 - Saved context

        [CanBeNull]
        [JsonProperty]
        public string ContextPath { get; set; }

        #endregion

        #region 2 - Limited time offer

        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<LtoModel> ActiveTimeLimitedOffers { get; set; }

        #endregion

        #region 3 - Cached events

        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<AppLaunchEvent> AppLaunchEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<CustomSessionEvent> CustomSessionEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<AppBackgroundEvent> AppBackgroundEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<TransactionEvent> TransactionEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<FirebaseMappingEvent> FirebaseMappingEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<MailingStatusMappingEvent> MailingStatusMappingEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<CampaignImpressionEvent> ImpressionEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<AdsImpressionEvent> ApplovinAdsImpressionEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<AdsImpressionEvent> IronSourceAdsImpressionEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<ImpressionFailEvent> ImpressionFailEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<ProductPurchaseEvent> TrialActivationEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<ProductPurchaseEvent> PaidSubscriptionActivationEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<ProductPurchaseEvent> InAppEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<CampaignImpressionEvent> ClickEvents { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<CampaignImpressionEvent> AdsClickEvents { get; set; }

        #endregion

        #region 4 - Purchase records

        [CanBeNull]
        [JsonProperty]
        public IReadOnlyCollection<PurchaseRecord> PurchasedRecords { get; set; }

        #endregion

        #region 5 - General prefs

        [CanBeNull]
        [JsonProperty]
        public string ClientId { get; set; }
        [CanBeNull]
        [JsonProperty]
        public string FirstInstalledVersion { get; set; }
        [JsonProperty]
        public DateTime? FirstLaunchDate { get; set; }
        [JsonProperty]
        public SubscriptionStatus? SubscriptionStatus { get; set; }
        [JsonProperty]
        public InAppStatus? InAppStatus { get; set; }
        [JsonProperty]
        public AuthorizationStatus? AuthorizationStatus { get; set; }
        [CanBeNull]
        [JsonProperty]
        public string ReferrerId { get; set; }
        [CanBeNull]
        [JsonProperty]
        public string AdjustId { get; set; }
        [CanBeNull]
        [JsonProperty]
        public string GpsAdId { get; set; }
        [JsonProperty]
        public bool? IsGdprGranted { get; set; }
        [JsonProperty]
        public bool? AttAuthorizationStatus { get; set; }
        [CanBeNull]
        [JsonProperty]
        public ISet<string> UsedDefaultCampaignTypes { get; set; }
        [CanBeNull]
        [JsonProperty]
        public IDictionary<string, DateTime> ProductsReceiptTimestamps { get; set; }
        [CanBeNull]
        [JsonProperty]
        public ISet<string> PurchasedInAppProducts { get; set; }
        [CanBeNull]
        [JsonProperty]
        public ISet<string> PurchasedSubscriptionProducts { get; set; }
        [CanBeNull]
        [JsonProperty]
        public ISet<string> UsedFreeProducts { get; set; }
        [CanBeNull]
        [JsonProperty]
        public string FirebaseInstanceId { get; set; }
        [JsonProperty]
        public int? GlobalSessionCounter { get; set; }
        [CanBeNull]
        [JsonProperty]
        public string SessionId { get; set; }
        [JsonProperty]
        public long? SessionStarted { get; set; }
        [JsonProperty]
        public long? LastActivity { get; set; }
        [JsonProperty]
        public MediaSource? MediaSource { get; set; }

        #endregion

        public override string ToString()
        {
            return JsonFacade.SerializeObject(this);
        }
    }
}