#if UNITY_EDITOR || UNITY_IOS
using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    internal class IOSLegacyCountersStorage : IDisposable
    {
        private readonly BinaryStorage _storage;
        private readonly MagifyLogger _logger = MagifyLogger.Get(LoggingScope.Migration);

        public void Dispose()
        {
            _storage?.Dispose();
        }

        public IOSLegacyCountersStorage(string storagePath)
        {
            _storage = BinaryStorage
                .Construct(storagePath)
                .AddEntry(BinaryTypeString.Shared)
                .AddEntry(BinaryTypeInt32.Shared)
                .SupportDictionariesOf<string, int>()
                .Build();
        }

        public int? GetGlobalCounter([NotNull] string scope, [NotNull] string key)
        {
            _logger.Log($"{nameof(GetGlobalCounter)} called for scope: {scope}, key: {key}");

            if (_storage.GetDictionary<string, int>(scope).Remove(key, out var value))
            {
                return value;
            }

            return null;
        }

        public void MigrateCounters(Dictionary<string, Dictionary<string, int>> counters)
        {
            using (_storage.MultipleChangeScope())
            {
                foreach (var scopeEntry in counters)
                {
                    var counterScopeDictionary = _storage.GetDictionary<string, int>(scopeEntry.Key);

                    foreach (var counterEntry in scopeEntry.Value)
                    {
                        counterScopeDictionary.Add(counterEntry.Key, counterEntry.Value);
                    }
                }
            }
        }
    }
}
#endif