﻿using JetBrains.Annotations;
using Magify.Rx;

namespace Magify
{
    internal static class ReactivePropertyExtensions
    {
        [NotNull]
        public static NotNullReactiveProperty<T> AsNotNull<T>([NotNull] this IReactiveProperty<T> reactiveProperty, [CanBeNull] T defaultValueIfNull)
        {
            reactiveProperty.Value ??= defaultValueIfNull;
            return new NotNullReactiveProperty<T>(reactiveProperty);
        }
    }
}