using System.Collections.Generic;
using System.Linq;
using JetBrains.Annotations;
using Magify.Model;

namespace Magify
{
    public static class CampaignExtensions
    {
        internal static bool IsSupportNested(this ICampaign campaign)
        {
            return campaign.Type.IsSupportNested() is true;
        }

        [ContractAnnotation("=> true,result:notnull; => false,result:null")]
        internal static bool TryGetNestedByProduct([NotNull] this CampaignRequest campaignRequest, [NotNull] string productId, [CanBeNull] PurchaseStore? store, out NestedCampaign result)
        {
            if (campaignRequest.NestedCampaigns == null)
            {
                result = null;
                return false;
            }

            IEnumerable<NestedCampaign> enumerable = campaignRequest.NestedCampaigns;
            if (store != null)
                enumerable = enumerable.Where(p => p.StoreName == store);
            result = enumerable.FirstOrDefault(p => p.ProductId == productId);
            return result != null;
        }

        internal static bool TryGetNestedByName(this CampaignRequest campaignRequest, string nestedName, out NestedCampaign result)
        {
            result = campaignRequest.NestedCampaigns?.FirstOrDefault(p => p.Name == nestedName);
            return result != null;
        }
    }
}