using System;
using JetBrains.Annotations;
using Magify.Model;

namespace Magify
{
    public static class ActivationPeriodExtensions
    {
        internal static DateTime GetStartTime([NotNull] this ActivationPeriod period)
        {
            var currentTime = DateTime.Now;
            var targetDate = new DateTime(currentTime.Ticks);
            targetDate = targetDate.AddDays(-(int)targetDate.DayOfWeek).AddDays((int)period.StartDay!);

            if (period.InsideDaysInterval(currentTime))
            {
                if (targetDate.Ticks > currentTime.Ticks)
                {
                    targetDate = targetDate.AddDays(-7);
                }
            }
            else if (targetDate.Ticks < currentTime.Ticks)
            {
                targetDate = targetDate.AddDays(7);
            }
            
            return new DateTime(
                targetDate.Year,
                targetDate.Month,
                targetDate.Day,
                period.StartTime!.Value.Hour,
                period.StartTime.Value.Minute,
                period.StartTime.Value.Second
            );
        }

        internal static DateTime GetEndTime([NotNull] this ActivationPeriod period)
        {
            var currentTime = DateTime.Now;
            var targetDate = new DateTime(currentTime.Ticks);
            targetDate = targetDate.AddDays(-(int)targetDate.DayOfWeek).AddDays((int)period.EndDay!);

            if (targetDate.Ticks < currentTime.Ticks)
            {
                targetDate = targetDate.AddDays(7);
            }
            
            return new DateTime(
                targetDate.Year,
                targetDate.Month,
                targetDate.Day,
                period.EndTime!.Value.Hour,
                period.EndTime.Value.Minute,
                period.EndTime.Value.Second
            );
        }

        private static bool InsideDaysInterval([NotNull] this ActivationPeriod period, DateTime date)
        {
            if (period.EndDay >= period.StartDay)
                return date.DayOfWeek >= period.StartDay && date.DayOfWeek <= period.EndDay;

            return date.DayOfWeek >= period.StartDay || date.DayOfWeek <= period.EndDay;
        }
    }
}