﻿using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Magify.Model;
using Magify.Rx;
using UnityEngine;

namespace Magify
{
    internal class SegmentationsCollection : IContextListener
    {
        [NotNull]
        private static readonly MagifyLogger _logger = MagifyLogger.Get();

        [NotNull]
        private readonly ReactiveProperty<IReadOnlyList<string>> _values = new(Array.Empty<string>());
        [NotNull]
        private readonly object _lock = new();

        [NotNull]
        public IReadOnlyReactiveProperty<IReadOnlyList<string>> Values
        {
            get
            {
                lock (_lock)
                {
                    return _values;
                }
            }
        }

        public ConfigScope SuitableScope => ConfigScope.Segmentations;

        public void UpdateContext([NotNull] CampaignsContext context, ContextKind kind)
        {
            switch (kind)
            {
                case ContextKind.Default:
                    // ignore: might be received only from remote context
                    break;
                case ContextKind.Saved or ContextKind.Downloaded:
                    lock (_lock)
                    {
                        _values.Value = context.Segmentations ?? Array.Empty<string>();
                        _logger.Log($"Parsed segmentation list is: {string.Join('\n', _values.Value)}");
                    }
                    break;
            }
        }
    }
}