using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Magify.Model;

namespace Magify
{
    internal class CampaignsCollection : IContextListener
    {
        [NotNull]
        private IReadOnlyList<CampaignRecord> _currentCampaigns = ArraySegment<CampaignRecord>.Empty;
        [NotNull]
        private IReadOnlyList<CampaignRecord> _defaultCampaigns = ArraySegment<CampaignRecord>.Empty;
        [NotNull]
        private readonly object _lockCurrent = new();
        [NotNull]
        private readonly object _lockDefault = new();

        public ConfigScope SuitableScope => ConfigScope.Campaigns;

        [NotNull]
        public IReadOnlyList<CampaignRecord> CurrentCampaigns
        {
            get
            {
                lock (_lockCurrent)
                {
                    return _currentCampaigns;
                }
            }
            private set => _currentCampaigns = value;
        }

        [NotNull]
        public IReadOnlyList<CampaignRecord> DefaultCampaigns
        {
            get
            {
                lock (_lockDefault)
                {
                    return _defaultCampaigns;
                }
            }
            private set => _defaultCampaigns = value;
        }

        public void ResetCurrentCampaigns()
        {
            lock (_lockCurrent)
            {
                CurrentCampaigns = ArraySegment<CampaignRecord>.Empty;
            }
        }

        void IContextListener.UpdateContext([NotNull] CampaignsContext context, ContextKind kind)
        {
            switch (kind)
            {
                case ContextKind.Default:
                    lock (_lockDefault)
                    {
                        DefaultCampaigns = context.CampaignModels != null ? CampaignMapper.MapCampaigns(context.CampaignModels) : ArraySegment<CampaignRecord>.Empty;
                    }
                    break;
                case ContextKind.Saved or ContextKind.Downloaded:
                    lock (_lockCurrent)
                    {
                        CurrentCampaigns = context.CampaignModels != null ? CampaignMapper.MapCampaigns(context.CampaignModels) : ArraySegment<CampaignRecord>.Empty;
                    }
                    break;
            }
        }
    }
}