using JetBrains.Annotations;
using Magify.Model;

namespace Magify
{
    internal class CampaignRecord
    {
        public CampaignType Type => Info.Type;
        public string Name => Info.Name;

        [NotNull]
        public CampaignInfo Info { get; }

        [NotNull]
        public CampaignModel Campaign { get; }

        public CampaignRecord([NotNull] CampaignInfo info, [NotNull] CampaignModel campaign)
        {
            Info = info;
            Campaign = campaign;
        }
    }

    internal static class CampaignRecordExtensions
    {
        internal static bool HasPlacementRestrictedByPurchases(this CampaignRecord record)
        {
            return record.Type switch
            {
                CampaignType.Banner => true,
                _ => false
            };
        }
    }
}