using System;
using UnityEngine.Scripting;

namespace Magify
{
    [Preserve]
    internal class AuthorizationConfig
    {
        public string UserClientId { get; set; }
        public bool IsNewUser { get; init; }
        public string DeviceName { get; init; }
        public string DeviceVersion { get; init; }
        public string ApplicationName { get; init; }
        public string ApplicationVersion { get; init; }
        public Orientation SupportedOrientation { get; init; }
        public string SdkVersion { get; init; }
        public DateTime FirstLaunchDate { get; init; }
        public string LanguageCode { get; set; }
        public string CountryCode { get; set; }

        public override string ToString()
        {
            return JsonFacade.SerializeObject(this);
        }
    }
}