using System.Runtime.Serialization;

namespace Magify
{
    internal enum SourceType
    {
        [EnumMember(Value = "event")]
        Event,
        [EnumMember(Value = "trigger")]
        Trigger,
        [EnumMember(Value = "placement")]
        Placement
    }

    internal class CampaignSource
    {
        public string Name { get; init; }
        public SourceType Type { get; init; }

        public CampaignSource(string name, SourceType type)
        {
            Name = name;
            Type = type;
        }
    }

    internal static class CampaignSourceExtensions
    {
        public static bool HasImpressionLimits(this SourceType sourceType)
        {
            return sourceType switch
            {
                SourceType.Event or SourceType.Trigger => true,
                SourceType.Placement => false,
                _ => false
            };
        }
    }
}