using System.Collections.Generic;
using JetBrains.Annotations;
using Magify.Model;

namespace Magify
{
    internal class CampaignInfo
    {
        public string Name { get; init; }
        public CampaignType Type { get; init; }
        public CampaignSubscriptionStatus SubscriptionStatus { get; init; }
        public CampaignInAppStatus InAppStatus { get; init; }
        public CampaignAuthorizationStatus AuthorizationStatus { get; init; }
        public CampaignPayingStatus PayingStatus { get; init; }
        [CanBeNull]
        public List<Event> Events { get; init; }
        [CanBeNull]
        public List<string> Placements { get; init; }
        [CanBeNull]
        public ImpressionLimits ImpressionLimits { get; init; }
        public int? ClickLimit { get; init; }
        public PurchaseLimits PurchaseLimits { get; init; }
        public ReferrerLimits ReferrerLimits { get; init; }
        public GrantLimits RewardGrantLimits { get; init; }
        public GrantLimits BonusGrantLimits { get; init; }
    }
}