﻿using System;

namespace Magify
{
    public class MagifyMigrationWrongTypeException : MagifyException
    {
        public MagifyMigrationWrongTypeException(Type expected, Type found) :
            base($"Migration data type mismatch. Expected: {expected}, but found: {found}.")
        {
        }

        public MagifyMigrationWrongTypeException(Type expected, Type found, Exception innerException) :
            base($"Migration data type mismatch. Expected: {expected}, but found: {found}.", innerException)
        {
        }
    }
}