﻿using System;
using JetBrains.Annotations;

namespace Magify
{
    public class MagifyMigrationFailedException : MagifyException
    {
        public MagifyMigrationFailedException(
            [NotNull] string scope,
            [CanBeNull] string additionalInfo,
            [NotNull] Exception innerException)
            : base($"Failed to migrate {scope} with exception. " +
                   $"\nInterException: {innerException.Message}" +
                   $"\nAdditionalInfo: {additionalInfo}",
                innerException)
        {
        }
    }
}