﻿using System;
using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    public class MagifyFailedToParseRestoreProgressResponseException : MagifyException
    {
        public MagifyFailedToParseRestoreProgressResponseException([CanBeNull] string response, [NotNull] Exception innerException)
            : base($"Magify failed to parse restore state response, {response?[..Mathf.Clamp(response.Length, 0, 100)] ?? "null"}...", innerException)
        {
        }
    }
}