﻿using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    public class MagifyFailedToBuildWebRequestException : MagifyException
    {
        internal MagifyFailedToBuildWebRequestException([NotNull] IEnumerable<IUnityWebRequestBuilder> builders)
            : base($"Magify failed to build web request, used builders: {JsonFacade.SerializeObject(builders)}")
        {
        }
    }
}