﻿using System;

namespace Magify
{
    public class MagifyFailedToAccessToNativeStorageException : MagifyException
    {
        public enum NativeStorageKind
        {
            IOSKeychain,
        }

        public enum NativeStorageAccessKind
        {
            Get,
            Set,
            Remove,
        }

        public MagifyFailedToAccessToNativeStorageException(NativeStorageKind nativeStorageKind, NativeStorageAccessKind accessKind, string key, Exception innerException)
            : base($"Magify failed to access with method {accessKind} to native storage {nativeStorageKind} by key {key}", innerException)
        {
        }
    }
}