using UnityEngine;

namespace Magify
{
    internal class BundleLocalStorage : LocalStorage<AssetBundle>
    {
        protected override AssetBundle LoadFromStreamingAssets(string url)
        {
            _logger.Log($"{nameof(LoadFromStreamingAssets)} from {url}");
            var bundleBytes = BetterStreamingAssets.ReadAllBytes(url);
            _logger.Log($"Success load default bundle from {url}");
            return AssetBundle.LoadFromMemory(bundleBytes);
        }

        protected override void ReleaseContent(AssetBundle content)
        {
            content.Unload(true);
        }
    }
}