﻿
using JetBrains.Annotations;

namespace Magify
{
    public partial class MagifyManager
    {
        public static class GameState
        {
            public static void SetGameMode([CanBeNull] string mode)
            {
                ThrowIfMagifyIsNotReady(nameof(SetGameMode));
                MagifyPlatformAPI!.SetGameMode(mode);
            }

            public static void SetGameLevel(int level)
            {
                ThrowIfMagifyIsNotReady(nameof(SetGameLevel));
                MagifyPlatformAPI!.SetGameLevel(level);
            }

            public static void SetGameMaxLevel(int level)
            {
                ThrowIfMagifyIsNotReady(nameof(SetGameMaxLevel));
                MagifyPlatformAPI!.SetGameMaxLevel(level);
            }
        }
    }
}