using System.Collections.Generic;
using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    public partial class MagifyManager
    {
        public static class Content
        {
            [NotNull]
            private static readonly MagifyLogger _logger = MagifyLogger.Get(LoggingScope.Content);

            [NotNull]
            public static IList<ContentItem> GetContentList([NotNull] string group, [NotNull] string key, [CanBeNull] List<string> tags = null)
            {
                ThrowIfMagifyIsNotReady($"{nameof(Content)}.{nameof(GetContentList)}");
                _logger.Log($"Get content list. {nameof(group)}={group}; {nameof(key)}={key}; {nameof(tags)}={(tags is null ? string.Empty : JsonFacade.SerializeObject(tags))}");
                var result = MagifyPlatformAPI!.GetContentList(group, key, tags);
                _logger.Log($"Get content list result: {JsonFacade.SerializeObject(result)}");
                return result;
            }

            [CanBeNull]
            public static ContentItem GetEarliestContent([NotNull] string group, [NotNull] string key)
            {
                ThrowIfMagifyIsNotReady($"{nameof(Content)}.{nameof(GetEarliestContent)}");
                _logger.Log($"Get earliest content. {nameof(group)}={group}; {nameof(key)}={key};");
                var result = MagifyPlatformAPI!.GetEarliestContent(group, key);
                _logger.Log($"Get earliest content: {(result is null ? string.Empty : JsonFacade.SerializeObject(result))}");
                return result;
            }

            [CanBeNull]
            public static ContentItem GetLatestContent([NotNull] string group, [NotNull]string key)
            {
                ThrowIfMagifyIsNotReady($"{nameof(Content)}.{nameof(GetLatestContent)}");
                _logger.Log($"Get latest content. {nameof(group)}={group}; {nameof(key)}={key};");
                var result = MagifyPlatformAPI!.GetLatestContent(group, key);
                _logger.Log($"Get latest content: {(result is null ? string.Empty : JsonFacade.SerializeObject(result))}");
                return result;
            }
        }
    }
}