﻿// Old native plugins are no longer supported
#if false
using System;
using System.Collections;
using System.Collections.Generic;
using Newtonsoft.Json;
using UnityEngine;

namespace Magify
{
    internal class NativeFeaturesProvider : IFeatures
    {
        public event Action<ConfigKind> OnUpdate;

        private readonly Dictionary<string, bool> _defaultBooleans = new();
        private readonly Dictionary<string, double> _defaultNumbers = new();
        private readonly Dictionary<string, string> _defaultStrings = new();

        private readonly Dictionary<string, bool> _currentBooleans = new();
        private readonly Dictionary<string, double> _currentNumbers = new();
        private readonly Dictionary<string, string> _currentStrings = new();
        private readonly MagifyLogger _logger = MagifyLogger.Get(LoggingScope.Features);

        private TaskScheduler _taskScheduler;
        private bool _isInitialized;

        public bool IsCurrentFeaturesParsed { get; private set; }

        internal void Setup(TaskScheduler taskScheduler, string defaultFeaturesJson, string currentFeaturesJson)
        {
            _taskScheduler = taskScheduler;

            _logger.Log($"Parse default features: \n{defaultFeaturesJson}");
            TryParseFeatures(defaultFeaturesJson, _defaultBooleans, _defaultNumbers, _defaultStrings);

            _logger.Log($"Parse current features: \n{currentFeaturesJson}");
            if (TryParseFeatures(currentFeaturesJson, _currentBooleans, _currentNumbers, _currentStrings)) IsCurrentFeaturesParsed = true;
            _isInitialized = true;
        }

        internal void UpdateCurrentFeatures(string currentFeaturesJson)
        {
            if (!_isInitialized)
            {
                _logger.Log($"{nameof(NativeFeaturesProvider)} has not been initialized before {nameof(UpdateCurrentFeatures)} call.");
                return;
            }
            _logger.Log($"{nameof(OnUpdate)} has been called.");
            _taskScheduler.Enqueue(() =>
                {
                    _logger.Log($"Parse remote features: \n{currentFeaturesJson}");
                    if (TryParseFeatures(currentFeaturesJson, _currentBooleans, _currentNumbers, _currentStrings))
                    {
                        IsCurrentFeaturesParsed = true;
                        throw new NotImplementedException();
                        OnUpdate?.Invoke(default);
                    }
                }, $"[{nameof(OnUpdate)}]");
        }

        public bool TryGetBool(string featureName, out bool result)
        {
            return TryGetFeature(featureName, _defaultBooleans, _currentBooleans, out result);
        }

        public bool GetBool(string featureName)
        {
            if (!TryGetBool(featureName, out var result)) throw new ArgumentException($"Can't find {nameof(Boolean)} feature {featureName}");
            return result;
        }

        public bool TryGetNumber(string featureName, out double result)
        {
            return TryGetFeature(featureName, _defaultNumbers, _currentNumbers, out result);
        }

        public double GetNumber(string featureName)
        {
            if (!TryGetNumber(featureName, out var result)) throw new ArgumentException($"Can't find {nameof(Double)} feature {featureName}");
            return result;
        }

        public bool TryGetString(string featureName, out string result)
        {
            return TryGetFeature(featureName, _defaultStrings, _currentStrings, out result);
        }

        public string GetString(string featureName)
        {
            if (!TryGetString(featureName, out var result)) throw new ArgumentException($"Can't find {nameof(String)} feature {featureName}");
            return result;
        }

        public void SetIgnoredFeatures(IEnumerable<string> features, FeatureSource source) => throw new NotImplementedException();

        private bool TryGetFeature<T>(string featureName, IReadOnlyDictionary<string, T> defaultMap, IReadOnlyDictionary<string, T> currentMap, out T result)
        {
            _logger.Log($"TryGetFeature {featureName} \nCurrentFeatures:{JsonFacade.SerializeObject(currentMap)} \nDefaultFeatures {JsonFacade.SerializeObject(defaultMap)}");
            if (currentMap != null && currentMap.TryGetValue(featureName, out result)) return true;
            if (defaultMap != null && defaultMap.TryGetValue(featureName, out result)) return true;
            result = default;
            return false;
        }

        private bool TryParseFeatures(
            string json,
            IDictionary<string, bool> booleans,
            IDictionary<string, double> numbers,
            IDictionary<string, string> strings)
        {
            booleans.Clear();
            numbers.Clear();
            strings.Clear();

            if (JsonFacade.IsNullOrEmpty(json)) return false;
            Dictionary<string, object> raw;
            try
            {
                raw = JsonFacade.DeserializeObject<Dictionary<string, object>>(json);
            }
            catch (Exception e)
            {
                _logger.LogError($"Can't parse json with features to Dictionary<string, object>. See error below\n{json}");
                _logger.LogException(e);
                return false;
            }

            foreach (var feature in raw)
                switch (feature.Value)
                {
                    case bool value:
                        _logger.Log($"Key={feature.Key}. OriginalType={feature.Value.GetType().Name}; ConvertedType={nameof(Boolean)}. Value={value}");
                        booleans[feature.Key] = value;
                        break;
                    case short value:
                        _logger.Log($"Key={feature.Key}. OriginalType={feature.Value.GetType().Name}; ConvertedType={nameof(Double)}. Value={value}");
                        numbers[feature.Key] = value;
                        break;
                    case int value:
                        _logger.Log($"Key={feature.Key}. OriginalType={feature.Value.GetType().Name}; ConvertedType={nameof(Double)}. Value={value}");
                        numbers[feature.Key] = value;
                        break;
                    case long value:
                        _logger.Log($"Key={feature.Key}. OriginalType={feature.Value.GetType().Name}; ConvertedType={nameof(Double)}. Value={value}");
                        numbers[feature.Key] = value;
                        break;
                    case float value:
                        _logger.Log($"Key={feature.Key}. OriginalType={feature.Value.GetType().Name}; ConvertedType={nameof(Double)}. Value={value}");
                        numbers[feature.Key] = value;
                        break;
                    case double value:
                        _logger.Log($"Key={feature.Key}. OriginalType={feature.Value.GetType().Name}; ConvertedType={nameof(Double)}. Value={value}");
                        numbers[feature.Key] = value;
                        break;
                    case string value:
                        _logger.Log($"Key={feature.Key}. OriginalType={feature.Value.GetType().Name}; ConvertedType={nameof(String)}. Value={value}");
                        strings[feature.Key] = value;
                        break;
                    case IList value:
                        _logger.Log($"Key={feature.Key}. OriginalType={feature.Value.GetType().Name}; ConvertedType={nameof(String)}. Value={JsonFacade.SerializeObject(feature.Value)}");
                        strings[feature.Key] = JsonFacade.SerializeObject(value);
                        break;
                    default:
                        _logger.Log($"Key={feature.Key}. OriginalType={feature.Value?.GetType().Name}; ConvertedType={nameof(String)}. Value={JsonFacade.SerializeObject(feature.Value)}");
                        strings[feature.Key] = JsonFacade.SerializeObject(feature.Value);
                        break;
                }

            _logger.Log(numbers.Count == 0, "Numbers: Empty");
            _logger.Log(numbers.Count > 0, $"Numbers:\n{JsonFacade.SerializeObject(numbers, Formatting.Indented)}");

            _logger.Log(strings.Count == 0, "Strings: Empty");
            _logger.Log(strings.Count > 0, $"Strings:\n{JsonFacade.SerializeObject(strings, Formatting.Indented)}");

            _logger.Log(booleans.Count == 0, "Booleans: Empty");
            _logger.Log(booleans.Count > 0, $"Booleans:\n{JsonFacade.SerializeObject(booleans, Formatting.Indented)}");

            return raw.Count > 0;
        }
    }

}
#endif