﻿using System;

namespace Magify
{
    internal static class UnixTimestamp
    {
        public static long ToUnixMilliseconds(this DateTime date)
        {
            return (long)(date - DateTime.UnixEpoch).TotalMilliseconds;
        }

        public static DateTime ToDateTime(int unixTimeStamp)
        {
            // Unix timestamp is seconds past epoch
            var dateTime = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
            return dateTime.AddSeconds(unixTimeStamp);
        }
    }
}