using System;
using System.Runtime.Serialization;
using JetBrains.Annotations;

namespace Magify.Types
{
    internal class Transaction
    {
        public string Id = Guid.NewGuid().ToString();
        public TransactionType Type;
        [CanBeNull]
        public string Source;

        public static Transaction CreateIncome(string source)
        {
            return new Transaction
            {
                Type = TransactionType.Income,
                Source = source
            };
        }

        public static Transaction CreateExpense()
        {
            return new Transaction
            {
                Type = TransactionType.Expense
            };
        }

        public static Transaction CreateCorrection()
        {
            return new Transaction
            {
                Type = TransactionType.Correction
            };
        }
    }

    internal enum TransactionType
    {
        [EnumMember(Value = "receive")]
        Income,
        [EnumMember(Value = "spend")]
        Expense,
        [EnumMember(Value = "spend_correction")]
        Correction
    }
}