﻿namespace Magify
{
    public enum PurchaseVerificationResultCode
    {
        /// <summary> It means that during the purchase verification process some unexpected error occurred </summary>
        Fail = 0,
        /// <summary> It means that current purchase is valid </summary>
        Success = 1,
        /// <summary> It's normally won't be returned in a production build, because usually all apps already have configured validator for production </summary>
        DoesntSupport = 2,
        /// <summary> It means that current purchase is invalid </summary>
        Invalid = 3,
        /// <summary> It means that you provided invalid Google credentials for purchase verification </summary>
        InvalidGoogleCredentials = 4,
        /// <summary> This means that during the purchase verification, the SDK canceled the web request for internal reasons </summary>
        Cancelled = 5,
    }
}