namespace Magify
{
    public enum Orientation
    {
        Portrait = 1,
        Landscape = 2,
        Both = 3
    };

    internal static class OrientationExtensions
    {
        public static string GetDescription(this Orientation orientation)
        {
            return orientation switch
            {
                Orientation.Portrait => "portrait",
                Orientation.Landscape => "landscape",
                Orientation.Both => "both",
                _ => "unknown"
            };
        }
    }
}