﻿using JetBrains.Annotations;

namespace Magify
{
    internal class Option<T>
    {
        [NotNull]
        public static readonly Option<T> None =  new(default);

        [CanBeNull]
        public T Value { get; init; }

        public bool IsSome => !ReferenceEquals(this, None);
        public bool IsNone => ReferenceEquals(this, None);

        public Option([CanBeNull] T value)
        {
            Value = value;
        }
    }

    internal static class OptionExtensions
    {
        public static Option<T> SomeIfNotNull<T>([CanBeNull] this T value)
            where T : class
        {
            return value == null ? Option<T>.None : new Option<T>(value);
        }
    }
}