﻿using System;
using JetBrains.Annotations;

namespace Magify
{
    public class CustomClientId
    {
        public Guid Guid { get; }

        public CustomClientId([NotNull] string source)
        {
            if (source == null)
                throw new ArgumentNullException(nameof(source));
            Guid = GuidUtility.Create(Guid.Empty, source);
        }

        [NotNull]
        public override string ToString()
        {
            return Guid.ToString();
        }
    }
}