﻿using System.IO;
using System.Threading.Tasks;
using JetBrains.Annotations;

namespace Magify
{
    public class StoredAppFeatureContent
    {
        [CanBeNull]
        public string FilePath { get; init; }

        public StoredAppFeatureContent([CanBeNull] string filePath)
        {
            FilePath = filePath;
        }

        [CanBeNull]
        public FileStream GetFileStream()
        {
            if (FilePath == null || !File.Exists(FilePath))
            {
                return null;
            }

            return new FileStream(FilePath, FileMode.Open);
        }

        [CanBeNull]
        public Task<string> LoadString()
        {
            if (FilePath == null || !File.Exists(FilePath))
            {
                return null;
            }

            return File.ReadAllTextAsync(FilePath);
        }

        [CanBeNull]
        public Task<byte[]> LoadBytes()
        {
            if (FilePath == null || !File.Exists(FilePath))
            {
                return null;
            }

            return File.ReadAllBytesAsync(FilePath);
        }
    }
}