﻿namespace Magify
{
    public interface IPurchaseVerificationHandler
    {
        /// <summary>
        /// Here you can handle the result of the purchase verification and tell sdk what to do next
        /// </summary>
        /// <param name="result">
        /// The result of the purchase verification, that we received from server
        /// </param>
        /// <returns>
        /// You can return null if you want to sdk to handle the result by itself <br/>
        /// You can return null if the <i>result.Code</i> is <b>Success</b> or <b>Invalid</b>. In these cases, the sdk anyway will finish the purchase verification process. <br/>
        /// </returns>
        public RepeatState? HandlePurchaseVerification(PurchaseVerificationResult result);
    }
}