﻿using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    public class InAppProduct : ProductDef, IProductDefWithPurchaseStore
    {
        public bool IsConsumable { get; }
        public PurchaseStore Store { get; }

        public InAppProduct(
            [NotNull] string productId,
            bool isConsumable,
            PurchaseStore store,
            [CanBeNull] ProductCreative creative = null,
            [CanBeNull] IReadOnlyDictionary<string, object> context = null,
            [CanBeNull] IReadOnlyList<PayoutDef> payouts = null)
            : base(productId, creative, context, payouts)
        {
            IsConsumable = isConsumable;
            Store = store;
        }
    }
}