﻿using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    public class CrossPromoProduct : ProductDef
    {
        [NotNull]
        public string BundleId { get; }

        [NotNull]
        public string Url { get; }

        [CanBeNull]
        public IReadOnlyList<string> Schemas { get; }

        public CrossPromoProduct(
            [NotNull] string productId,
            [NotNull] string bundleId,
            [NotNull] string url,
            [CanBeNull] IReadOnlyList<string> schemas,
            [CanBeNull] ProductCreative creative = null,
            [CanBeNull] IReadOnlyDictionary<string, object> context = null,
            [CanBeNull] IReadOnlyList<PayoutDef> payouts = null) : base(productId, creative, context, payouts)
        {
            BundleId = bundleId;
            Url = url;
            Schemas = schemas;
        }
    }
}