﻿using System;
using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    public static class FlagsEnumExtensions
    {
        /// <remarks>
        /// Ignores 0 (usually None)
        /// </remarks>
        [NotNull, ItemNotNull]
        public static IEnumerable<T> EnumerateEach<T>([NotNull] this T flags) where T : Enum
        {
            foreach (Enum value in Enum.GetValues(typeof(T)))
            {
                if (flags.HasFlag(value))
                {
                    if (Convert.ToInt64(value) != 0)
                        yield return (T)value;
                }
            }
        }
    }
}