﻿using System.Collections.Generic;

namespace Magify
{
    public class InAppCampaign : ICampaignWithCreative, ICampaignWithProducts, ICampaignWithPurchaseStore
    {
        public CampaignType Type { get; init; } = CampaignType.InApp;
        public string Name { get; init; }

        public ICreative Creative { get; init; }
        public IReadOnlyList<InAppProduct> Products { get; init; }
        public PurchaseStore Store { get; init; }

        IReadOnlyList<ProductDef> ICampaignWithProducts.Products => Products;
    }
}