﻿using System;
using JetBrains.Annotations;

namespace Magify
{
    public class AutoRestoreStateInfo
    {
        public enum StateKind
        {
            NotStarted,
            InProgress,
            Success,
            NothingToRestore,
            Failed,
            Cancelled,
        }

        public StateKind Kind { get; init; } = StateKind.NotStarted;

        [CanBeNull]
        public string ErrorMessage { get; init; }

        [CanBeNull]
        public Exception Exception { get; init; }

        [NotNull]
        internal static AutoRestoreStateInfo Success()
        {
            return new AutoRestoreStateInfo
            {
                Kind = StateKind.Success,
            };
        }

        [NotNull]
        internal static AutoRestoreStateInfo NothingToRestore()
        {
            return new AutoRestoreStateInfo()
            {
                Kind = StateKind.NothingToRestore,
            };
        }

        [NotNull]
        internal static AutoRestoreStateInfo InProgress()
        {
            return new AutoRestoreStateInfo()
            {
                Kind = StateKind.InProgress,
            };
        }

        [NotNull]
        internal static AutoRestoreStateInfo NotStarted()
        {
            return new AutoRestoreStateInfo()
            {
                Kind = StateKind.NotStarted,
            };
        }

        [NotNull]
        internal static AutoRestoreStateInfo Failed([CanBeNull] string errorMessage, [CanBeNull] Exception exception)
        {
            return new AutoRestoreStateInfo()
            {
                Kind = StateKind.Failed,
                ErrorMessage = errorMessage,
                Exception = exception,
            };
        }

        [NotNull]
        internal static AutoRestoreStateInfo Cancelled()
        {
            return new AutoRestoreStateInfo()
            {
                Kind = StateKind.Cancelled,
                ErrorMessage = "Automatic restore state operation was cancelled",
            };
        }
    }
}