﻿using System.Runtime.Serialization;
using UnityEngine.Scripting;

namespace Magify
{
    [Preserve]
    public enum AghanimOrderStatus
    {
        [EnumMember(Value = "pending"), Preserve]
        Pending,
        [EnumMember(Value = "paid"), Preserve]
        Paid,
        [EnumMember(Value = "cancelled"), Preserve]
        Cancelled,
    }

    public static class AghanimOrderStatusExtensions
    {
        public static bool IsFinal(this AghanimOrderStatus status)
        {
            return status is AghanimOrderStatus.Paid or AghanimOrderStatus.Cancelled;
        }
    }
}