#if UNITY_LOCALIZATION
namespace Magify
{
    using System.Collections.Generic;
    using System.Linq;
    using UnityEngine;
    using UnityEngine.Localization;
    using UnityEngine.Localization.Settings;

    public class BundleLocalization : MonoBehaviour
    {
        [SerializeField]
        internal bool _compatibleWithAnyLocales;
        [SerializeField]
        internal List<Locale> _includeLocales = new();
        [SerializeField]
        internal List<Locale> _excludeLocales  = new();

        public List<string> GetAvailableLocales()
        {
            if (_compatibleWithAnyLocales)
            {
                return LocalizationSettings.AvailableLocales.Locales.Except(_excludeLocales.Where(l => l)).Select(t => t.Identifier.Code).ToList();
            }

            return _includeLocales.Where(l => l).Select(t => t.Identifier.Code).ToList();
        }
    }
}
#else
namespace Magify
{
    using System.Collections.Generic;
    using UnityEngine;

    public class BundleLocalization : MonoBehaviour
    {
        public List<string> GetAvailableLocales() => new List<string>() { "en" };
    }
}
#endif