﻿using UnityEditor;

namespace Magify
{
    [CustomEditor(typeof(ArcLayoutGroup))]
    public class ArcLayoutGroupEditor : Editor
    {
        private SerializedProperty _alignSerializedProperty;
        private SerializedProperty _arcAngleSerializedProperty;
        private SerializedProperty _offsetSerializedProperty;

        private void OnEnable()
        {
            _alignSerializedProperty = serializedObject.FindProperty("_align");
            _arcAngleSerializedProperty = serializedObject.FindProperty("_arcAngle");
            _offsetSerializedProperty = serializedObject.FindProperty("_offset");
        }

        public override void OnInspectorGUI()
        {
            EditorGUILayout.PropertyField(_alignSerializedProperty);
            EditorGUILayout.PropertyField(_arcAngleSerializedProperty);
            EditorGUILayout.PropertyField(_offsetSerializedProperty);

            serializedObject.ApplyModifiedProperties();
        }
    }
}