using System;
using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    internal readonly struct HandlePauseTimeOnFocusGainedWorkerJob : IMagifyWorkerJob
    {
    }

    internal class HandlePauseTimeOnFocusGainedWorker : IMagifyWorker<HandlePauseTimeOnFocusGainedWorkerJob>
    {
        [NotNull]
        private static readonly MagifyLogger _logger = MagifyLogger.Get();
        [NotNull]
        private readonly ServicePrefs _prefs;
        [NotNull]
        private readonly MagifySettings _settings;
        [NotNull]
        private readonly ServiceTime _time;

        public HandlePauseTimeOnFocusGainedWorker(
            [NotNull] ServicePrefs prefs,
            [NotNull] MagifySettings settings,
            [NotNull] ServiceTime time)
        {
            _prefs = prefs;
            _settings = settings;
            _time = time;
        }

        public void DoJob([NotNull] HandlePauseTimeOnFocusGainedWorkerJob job)
        {
            if (_prefs.PauseTime.Value != default)
            {
                var seconds = (DateTime.UtcNow - _prefs.PauseTime.Value).TotalSeconds;
                if (seconds > _settings.ForceSyncOnFocusAfter)
                {
                    _logger.Log($"Mono event OnApplicationFocus(true) fired after long time ({seconds}s) - call {nameof(MagifyManager)}.{nameof(MagifyManager.Sync)}");
                    _time.MarkAsUnprotected();
                    MagifyManager.Sync();
                }
            }

            _prefs.PauseTime.Value = default;
        }
    }
}