﻿using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    public class OpenLinkAndWaitRestoreHandler : IExternalLinkHandler
    {
        [NotNull]
        private static readonly MagifyLogger _logger = MagifyLogger.Get(MagifyService.LogScope);

        public async UniTask Open([NotNull] string url, CancellationToken cancellationToken)
        {
            var restoreType = await ApplicationHelper.CallAndWaitForApplicationRestore(open, cancellationToken);
            _logger.Log($"The user went out of the background after opening link {url}. Restore type is {restoreType}");
            return;

            void open() => Application.OpenURL(url);
        }
    }
}