using System;
using JetBrains.Annotations;
using UnityEngine.Events;
using UnityEngine.UI;

namespace Magify
{
    internal static class ButtonExtensions
    {
        internal static IDisposable SubscribeOnClick([NotNull] this Button button, [NotNull] UnityAction action)
        {
            if (button != null && button.onClick != null)
            {
                button.onClick.AddListener(action);
            }
            return new Subscription(unsubscribe);

            void unsubscribe()
            {
                if (button != null && button.onClick != null)
                {
                    button.onClick.RemoveListener(action);
                }
            }
        }
    }
}