using System.Collections.Generic;
using Magify.Rx;

namespace Magify
{
    public class PricesHelper
    {
        private readonly ILocalizer _localizer;
        private readonly Dictionary<string, ReactiveProperty<string>> _properties = new();

        public IReactiveProperty<string> this[string productId] => GetProperty(productId);

        internal PricesHelper(ILocalizer localizer)
        {
            _localizer = localizer;
        }

        public void UpdatePriceFor(string productId, string localizedPriceString)
        {
            GetProperty(productId).Value = localizedPriceString;
        }

        private ReactiveProperty<string> GetProperty(string productId)
        {
            if (!_properties.TryGetValue(productId, out var prop))
            {
                var text = _localizer.Localize(LocalizationKey.BuyLabel);
                prop = new ReactiveProperty<string>(text);
                _properties[productId] = prop;
            }
            return prop;
        }
    }
}