using System.Diagnostics.CodeAnalysis;
using Magify.Rx;
using TMPro;
using UnityEngine;

namespace Magify
{
    public class ErrorPopup : Popup<ErrorPopup.Args>
    {
        public class Args : PopupArgs
        {
            public Type Type { get; }

            public Args(Type type, [NotNull] ILocalizer localizer)
            {
                Type = type;
                Localizer = localizer;
            }
        }

        public enum Type
        {
            Unknown,
            NoInternet,
        }

        [SerializeField]
        private TextMeshProUGUI _description;

        protected override void PrepareForShow(Args arguments, CompositeDisposable disposables)
        {
            base.PrepareForShow(arguments, disposables);
            var text = arguments.Localizer.Localize(arguments.Type);
            _description.SetText(text);
        }
    }
}