﻿using System.Collections.Generic;

namespace Magify
{
    public delegate void ProductFetchedDelegate(string productId);

    public delegate void ProductFetchFailedDelegate(string productId, ProductObtainFailReason reason);

    public delegate void PurchaseFinishedDelegate(string productId, PurchaseInfo purchaseInfo);

    public delegate void PurchaseFailedDelegate(string productId, ProductObtainFailReason reason);

    public interface IInAppStore : IMinimalInAppStore
    {
        event ProductFetchedDelegate OnProductFetched;
        event ProductFetchFailedDelegate OnProductFetchFailed;
        event PurchaseFailedDelegate OnPurchaseFailed;

        bool IsProductReady(ProductDef product);
        void LoadProducts(IEnumerable<ProductDef> products);
        void Purchase(ProductDef product);
    }

    public static class PurchasesProviderExtension
    {
        public static bool IsPurchasable(this ProductDef product)
        {
            return product is InAppProduct or SubscriptionProduct;
        }
    }
}